﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{ 
    public abstract class DeploymentAbstractFactory : AHOBPRBaseBO
    {
        protected string connectionInfo = string.Empty;
        public DeploymentAbstractFactory() { }
        public DeploymentAbstractFactory(string dbConnInfo)
        {
            connectionInfo = dbConnInfo;
        }
        protected abstract IDeployment Create(DoDDeploymentAdapter deployment);    
        public abstract List<IDeployment> CreateDeployments(eMISdeploymentResponseType deploymentResponse, Dictionary<DateRange, string> branchesOfService);
        public abstract List<IDeployment> CreateDeployments(eMISdeploymentResponseType deploymentResponse, RegistrantHistory history);
        protected static DateRange CreateNewDateRange(DateTime startDate, DateTime endDate)
        {
            //If they're active, it'll show up with a DateTime of 0/0/0001
            if (endDate.Day == 1 && endDate.Month == 1 && endDate.Year == 1)
            {
                endDate = DateTime.Parse("9999-11-11");
            }
            return new DateRange(startDate, endDate);
        }
    }
}
